PROGRAM Players;

USES DOS, MyProcs, OpCrt, OpDOS, OpRoot, OpCmd, OpSEdit;

TYPE

  PlayRec = RECORD
              Name : string[25];
              GamesPlayed,
              GamesWon,
              HiScore,
              TotalScores,
              TotalMoves,
              TotalPoints : integer;
            END;

VAR
  SLE  : SimpleLineEditor;
  Finished : boolean;
  ch   : char;
  Player : PlayRec;
  pFile : FILE OF PlayRec;
  CurrentRec, NumRecs : longint;

  PROCEDURE Init;
  BEGIN
    WITH Player DO
    BEGIN
      Name := '';
      GamesPlayed := 0; GamesWon := 0; HiScore := 0; TotalScores := 0;
      TotalMoves := 0; TotalPoints := 0;
    END;
  END;

  PROCEDURE EditRecord;
  VAR
    sTemp : string[25];
    code : integer;
  BEGIN
    IF CurrentRec = 0 THEN exit;
    CursorOn;
    SLE.Init(DefaultColorSet);
    SLE.seOptionsOff(seCursorToEnd + seClearFirstChar + seHouseCursorAtEnd + seInsertByDefault);
    WITH Player DO
    BEGIN
      SLE.ReadString('', 5, 22, 25, 25, Name);
      ChangeAttribute(25, 5, 22, NormalAttr);
      str(GamesPlayed, sTemp);
      SLE.seOptionsOn(seClearFirstChar);
      SLE.ReadString('', 6, 22, 3, 3, sTemp);
      ChangeAttribute(3, 6, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, GamesPlayed, code);
      str(GamesWon, sTemp);
      SLE.ReadString('', 7, 22, 3, 3, sTemp);
      ChangeAttribute(3, 7, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, GamesWon, code);
      str(HiScore, sTemp);
      SLE.ReadString('', 8, 22, 3, 3, sTemp);
      ChangeAttribute(3, 8, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, HiScore, code);
      str(TotalScores, sTemp);
      SLE.ReadString('', 9, 22, 3, 3, sTemp);
      ChangeAttribute(3, 9, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, TotalScores, code);
      str(TotalMoves, sTemp);
      SLE.ReadString('', 10, 22, 3, 3, sTemp);
      ChangeAttribute(3, 10, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, TotalMoves, code);
      str(TotalPoints, sTemp);
      SLE.ReadString('', 11, 22, 3, 3, sTemp);
      ChangeAttribute(3, 11, 22, NormalAttr);
      IF sTemp <> '' THEN val(sTemp, TotalPoints, code);
      SLE.Done;
      seek(pFile, CurrentRec - 1);
      write(pFile, Player);
      seek(pFile, CurrentRec - 1);
    END;
    CursorOff;
  END;

  PROCEDURE ShowRecord;
  BEGIN
    gotoxy(1, 3); write('Current Record: ', CurrentRec, ' of ', NumRecs);
    gotoxy(1, 5); ClrEol; write('Player''s Full Name : ', Player.Name);
    gotoxy(1, 6); ClrEol; write('Games Played       : ', Player.GamesPlayed);
    gotoxy(1, 7); ClrEol; write('Games Won          : ', Player.GamesWon);
    gotoxy(1, 8); ClrEol; write('High Score         : ', Player.HiScore);
    gotoxy(1, 9); ClrEol; write('Total Scores       : ', Player.TotalScores);
    gotoxy(1, 10); ClrEol; write('Total Moves        : ', Player.TotalMoves);
    gotoxy(1, 11); ClrEol; write('Combined Points    : ', Player.TotalPoints);
  END;

  PROCEDURE InsertRecord;
  BEGIN
    Init;
    inc(NumRecs);
    IF NumRecs > 1 THEN
    BEGIN
      seek(pFile, NumRecs - 1);
      write(pFile, Player);
      seek(pFile, NumRecs - 1);
    END;
    CurrentRec := NumRecs;
    ShowRecord;
    EditRecord;
  END;

  PROCEDURE DoRead;
  BEGIN
    seek(pFile, CurrentRec - 1);
    read(pFile, Player);
    seek(pFile, CurrentRec - 1);
  END;

  PROCEDURE DeleteRecord;
  VAR
    sTemp : string[25];
    fTemp : FILE OF PlayRec;
  BEGIN
    CursorOn;
    gotoxy(1, 20);
    sTemp := Player.Name;
    write('Remove:  ', sTemp, ' - from Players.Dat file? [Y/N]: ');
    REPEAT
      ch := upcase(Readkey);
    UNTIL ch IN ['Y', 'N'];
    CursorOff;
    gotoxy(1, 20); ClrEol;
    IF ch = 'N' THEN exit;
    assign(fTemp, 'Players.$$$');
    rewrite(fTemp);
    reset(pFile);
    WHILE NOT eof(pFile) DO
    BEGIN
      read(pFile, Player);
      IF Player.Name <> sTemp THEN
        write(fTemp, Player);
    END;
    close(pFile); close(fTemp);
    erase(pFile); rename(fTemp, 'Players.Dat');
    assign(pFile, 'Players.Dat');
    reset(pFile);
    Init;
    NumRecs := filesize(pFile);
    IF NumRecs > 0 THEN
    BEGIN
      CurrentRec := 1;
      DoRead;
    END
    ELSE
      CurrentRec := 0;
  END;

  PROCEDURE Process;
  BEGIN
    clrscr;
    write('       Quick Little Players.Dat file Editor - Christopher Hall');
    ShowRecord;
    gotoxy(1, 24); write('<T>op  <B>ottom  <N>ext  <P>revious  <E>dit  <I>nsert  <D>elete  <Q>uit');
    REPEAT
      ch := upcase(Readkey);
    UNTIL ch IN ['T', 'B', 'N', 'P', 'E', 'I', 'D', 'Q'];
    CASE ch OF
      'T' : IF (CurrentRec > 1) AND (NumRecs > 0) THEN
            BEGIN
              CurrentRec := 1;
              DoRead;
            END;
      'B' : IF (CurrentRec < NumRecs) THEN
            BEGIN
              CurrentRec := NumRecs;
              DoRead;
            END;
      'N' : IF CurrentRec < NumRecs THEN
            BEGIN
              inc(CurrentRec);
              DoRead;
            END;
      'P' : IF CurrentRec > 1 THEN
            BEGIN
              dec(CurrentRec);
              DoRead;
            END;
      'E' : EditRecord;
      'I' : InsertRecord;
      'D' : DeleteRecord;
      'Q' : Finished := true;
    END;
  END;

BEGIN
  clrscr;
  Finished := false; CurrentRec := 0; NumRecs := 0;
  Init;
  assign(pFile, 'Players.Dat');
  {$I-}
  reset(pFile);
  {$I+}
  IF ioresult <> 0 THEN
  BEGIN
    writeln('Players.Dat file NOT found!');
    write('Would you like to create it? [Y/N]: ');
    REPEAT
      ch := upcase(Readkey);
    UNTIL ch IN ['Y', 'N'];
    IF ch = 'N' THEN halt;
    rewrite(pFile);
  END
  ELSE
  BEGIN
    NumRecs := filesize(pFile);
    CurrentRec := 1;
    IF NumRecs > 0 THEN
      read(pFile, Player);
  END;
  CursorOff;
  REPEAT
    Process;
  UNTIL Finished;
  CursorOn;
  close(pFile);
  clrscr;
END.
