#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#if defined(_MSC_VER) || defined(WIN32)
#include <winsock2.h>
#include "MD_AnsiCons.h"
#define STDOUT_FILENO 1
#else
#include <sys/socket.h>
#include <unistd.h>
#endif
#include "MagiDoor.h"

void md_putchar(char c) {
#if defined(_MSC_VER) || defined(WIN32)
    ansi_write(stdout, &c, 1);
#endif
    if (mdcontrol.socket == -1) {
        write(STDOUT_FILENO, &c, 1);
    } else {
        send(mdcontrol.socket, &c, 1, 0);
    }
}

void md_set_cursor(int y, int x) {
    md_printf("\x1b[%d;%dH", y, x);
}

void md_clr_scr() {
    md_printf("\x1b[2J\x1b[1;1H");
}

void md_printcode(char *code) {
    char *part;
    int bright = 0;
    int colour = 0;
    int bgcolour = 0;
    char codebuffer[11];
    int i;

    part = strtok(code, " ");
    if (part != NULL) {
        if (strcmp(part, "bright") == 0) {
            bright = 1;
        } else if (strcmp(part, "black") == 0) {
            colour = 0;
        } else if (strcmp(part, "red") == 0) {
            colour = 1;
        } else if (strcmp(part, "green") == 0) {
            colour = 2;
        } else if (strcmp(part, "yellow") == 0) {
            colour = 3;
        } else if (strcmp(part, "blue") == 0) {
            colour = 4;
        } else if (strcmp(part, "magenta") == 0) {
            colour = 5;
        } else if (strcmp(part, "cyan") == 0) {
            colour = 6;
        } else if (strcmp(part, "white") == 0) {
            colour = 7;
        }
        part = strtok(NULL, " ");
        if (part != NULL) {
            if (bright == 0) {
                bgcolour = colour;
                colour = 0;
            }
            if (strcmp(part, "bright") == 0) {
                bright = 1;
                part = strtok(NULL, " ");
            }
            if (part != NULL) {

                if (strcmp(part, "black") == 0) {
                    colour = 0;
                } else if (strcmp(part, "red") == 0) {
                    colour = 1;
                } else if (strcmp(part, "green") == 0) {
                    colour = 2;
                } else if (strcmp(part, "yellow") == 0) {
                    colour = 3;
                } else if (strcmp(part, "blue") == 0) {
                    colour = 4;
                } else if (strcmp(part, "magenta") == 0) {
                    colour = 5;
                } else if (strcmp(part, "cyan") == 0) {
                    colour = 6;
                } else if (strcmp(part, "white") == 0) {
                    colour = 7;
                }                
            }
        }
    }

    snprintf(codebuffer, 11, "\x1b[%d;4%d;3%dm", bright, bgcolour, colour);

    for (i=0;i<10;i++) {
        md_putchar(codebuffer[i]);
    }
}

void md_printf(const char *fmt, ...) {
    char buffer[4096];
    char codebuf[128];
    va_list ap;

    va_start(ap, fmt);
    vsnprintf(buffer, sizeof buffer, fmt, ap);
	va_end(ap);

    char *ptr;
    char *cbptr;
    ptr = buffer;
    while (*ptr != '\0') {
        if (*ptr == '`') {
            ptr++;
            if (*ptr == '`') {
                md_putchar('`');
                ptr++;
                continue;
            } else if (*ptr == '\0') {
                break;
            }
            cbptr = codebuf;
            while(*ptr != '`' && *ptr != '\0' && cbptr - codebuf < 127) {
                *cbptr = *ptr;
                ptr++;
                cbptr++;
                *cbptr = '\0';
            }

            md_printcode(codebuf);

            if (*ptr == '\0') {
                break;
            }
            ptr++;
            continue;
        }
        md_putchar(*ptr);
        ptr++;
    }
}
