{$IFNDEF MSDOS}
{$I DEFINES.INC}
{$ENDIF}
 (********************************)
 (*   Programming:  Bob Dalton   *)
 (*   ERROR LOG UNIT - Vers 1.00 *)
 (*   Utility Module             *)
 (********************************)

unit Elog;

interface


var
  SaveExitProc: POINTER;

procedure Terminate(N: byte);
procedure TrapExit;
procedure MyExit1;

implementation   (********************************)

uses
  Crt, Dos, DDPlus,
  Netfilep, Jakob, File_Io {$IFDEF FPC}, RPPort{$ENDIF}; {jakob}

{$IFDEF MSDOS}
procedure GetDate1(var Month: word; var day: word; var year: word);
var MyRegs: Registers;

begin
  MyRegs.AH := $2A;
  MSDOS(MyRegs);
  Month := MyRegs.DH;
  Day := MyRegs.DL;
  Year := MyRegs.CX;
end;

{$ENDIF}
{$IFNDEF MSDOS}
procedure GetDate1(var Month: word; var day: word; var year: word);
var
  DOW: word;
begin
  GetDate(Year, Month, Day, DOW);
end;

{$ENDIF}

procedure Terminate(N: byte);
begin
  case N of
    0: begin  end;{SWriteln('Normal Termination'); jakob remmar bort}
    1: begin SWriteln('Carrier lost'); end;
    2: begin SWriteln('*** TIME LIMIT HAS EXPIRED ***'); end;
    3: begin SWriteln('User Inactive for 5+ minutes'); end;
  end;
end;

{$F+}

(* This exit procedure may be used to trap HALT codes.  If defined in the
   main body of your program (DoorExit := TrapExit), this procedure will be
   called whenever your program encounters a HALT code or runtime error.

   As shown below, if ErrorAddr <> NIL (no runtime error has occurred) the
   runtime error information is displayed to the local console and is also
   written to a file called PROG_ERR.LOG.  You may wish to change the name
   of this error log file to something more fitting to your program.
   If ErrorAddr = NIL then this code assumes that no runtime error has
   occurred but rather that a HALT code has been encountered.  You could
   conceivably handle all your HALT functions within the TRAPEXIT procedure.
   However, in this demonstration, we can see that we are passing the HALT
   code onto the TERMINATE procedure which is located within your program's
   code.
*)


procedure TrapExit;

const
  {Replace GodFather with the name of your program}

  ProductName = 'Usurper'; {jakob}
  logname     = 'ERROR.LOG'; {jakob}

var
  ErrFile:      Text;
  OpenAttempts: integer;
  GoAhead:      boolean;
  Year, Month, Day: word;


  function Exit_message(Code: integer): string;
    {return message text for a given exit code}
  var
    Msg: string;
  begin
    case Code of
      0: Msg := ''; {'Normal Termination'; jaokb tar bort}
      1: Msg := 'Carrier Lost';
      2: Msg := 'Time Limit Exceeded';
      3: Msg := 'User Inactivity Timeout';
      4: Msg := 'Cannot Find Dorinfo1.def';
      5: Msg := 'Cannot Find ExitInfo.Bbs';
      6: Msg := 'Directory Change/Read Error';
      7: Msg := 'CTS Timeout';
      8: Msg := 'Forced Exit via RAXIT Semaphore';
      9: Msg := 'Cannot Find Door.Sys';
      else STR(Code, Msg);
    end;
    Exit_Message := Msg;
  end;


  function Itoh(W: integer): string;
    {hex conversion}
  const
    Hex: array[0..15] of char = '0123456789ABCDEF';
  var
    H: string[4];
  begin
    H[0] := CHR(4);
    H[1] := Hex[(W shr 12) and $0f];
    H[2] := Hex[(W shr 8) and $0f];
    H[3] := Hex[(W shr 4) and $0f];
    H[4] := Hex[W and $0f];
    Itoh := H;
  end;

begin
  GetDate1(Month, day, year);
  if ErrorAddr = nil then
  begin
    if ExitCode = 0 then
    begin
      Terminate(0);
      Exit;
    end;

    {Replace the next line with the name of YOUR save procedure}
    {This ones save my game information should something go wrong}
    {I have left it so you see what I did, although it IS commented out}

    {SaveGame(Player,PlayerFile,TempP,Country,CountryFile,Map1,MapFile);}

    if ShareInst = False then
      FileMode := 64;
{$IFNDEF MSDOS}
    FileModeReadWrite := FileMode;
{$ENDIF}
    Assign(ErrFile, logname);
    if F_EXISTS(logname) then
    begin
      OpenAttempts := 1;
      repeat
        {$I-}
        Append(ErrFile);
        {$I+}
        GoAhead := (IOResult = 0);
        if not GoAhead then
        begin
          OpenAttempts := OpenAttempts + 1;
          releasetimeslice; {jakob}
        end;
      until (GoAhead) or (OpenAttempts > 15);
    end;
    if not F_EXISTS(logname) then
    begin
      OpenAttempts := 1;
      repeat
        {$I-}Rewrite(ErrFile);{$I+}
        GoAhead := (IOResult = 0);
        if not GoAhead then
        begin
          OpenAttempts := OpenAttempts + 1;
          releasetimeslice; {jakob}
        end;
      until (GoAhead) or (OpenAttempts > 15);
    end;
    if ProductName <> '' then
    begin
      Writeln_to_text(ErrFile, ' ');
      Writeln_to_text(ErrFile, 'Error Log Generated by ' + ProductName);
    end;
    WRITELN('Date : ', Month, '/', Day, '/', Year);
    WRITELN(' ');
    WRITELN('Program Termination');
    WRITELN(Exit_Message(Exitcode));
    WRITELN_to_text(ErrFile, 'Date : ' + commastr(Month) + '/' + commastr(Day) + '/' + commastr(Year)); {jakob}
    WRITELN_to_text(ErrFile, 'Program Termination');
    WRITELN_to_text(ErrFile, Exit_Message(Exitcode));
    Close_text(ErrFile); {jakob}
    if ShareInst = False then
      FileMode := 66;
{$IFNDEF MSDOS}
    FileModeReadWrite := FileMode;
{$ENDIF}
    {be sure to uncomment this if using RipLink}
     {if RIP <> nil then
      Dispose(RIP, Done);}
    Terminate(ExitCode);
    Delay2(1000);
  end else
  begin

    {Replace the next line with the name of YOUR save procedure}
    {This ones save my game information should something go wrong}
    {I have left it so you see what I did, although it IS commented out}

    {SaveGame(Player,PlayerFile,TempP,Country,CountryFile,Map1,MapFile);}

    Assign(ErrFile, logname);
    if F_EXISTS(logname) then
    begin
      OpenAttempts := 1;
      repeat
          {$I-}
        Append(ErrFile);
          {$I+}
        GoAhead := (IOResult = 0);
        if not GoAhead then
        begin
          OpenAttempts := OpenAttempts + 1;
          releasetimeslice; {jakob}
        end;
      until (GoAhead) or (OpenAttempts > 15);
    end;
    if not F_EXISTS(logname) then
    begin
      OpenAttempts := 1;
      repeat
          {$I-}Rewrite(ErrFile);{$I+}
        GoAhead := (IOResult = 0);
        if not GoAhead then
        begin
          OpenAttempts := OpenAttempts + 1;
          releasetimeslice; {jakob}
        end;
      until (GoAhead) or (OpenAttempts > 15);
    end;
    if ProductName <> '' then
    begin
      Writeln_to_text(ErrFile, ' ');
      Writeln_to_text(ErrFile, 'Error Log Generated by ' + ProductName);
    end;
    WRITELN('Date : ', Month, '/', Day, '/', Year);
    WRITELN('Run-time error occurred');
    WRITELN('Exitcode = ', exitcode);
    WRITELN(Error_Message(Exitcode));
    WRITELN('Address of error:');
    WRITELN('  Segment: ', ItoH(seg(erroraddr^)));
    WRITELN('  Offset:  ', ItoH(ofs(erroraddr^)));
    WRITELN_to_text(ErrFile, 'Date : ' + commastr(Month) + '/' + commastr(Day) + '/' + commastr(Year));
    WRITELN_to_text(ErrFile, 'Run-time error occurred');
    WRITELN_to_text(ErrFile, 'Exitcode = ' + commastr(exitcode));
    WRITELN_to_text(ErrFile, Error_Message(Exitcode));
    WRITELN_to_text(ErrFile, 'Address of error:');
    WRITELN(ErrFile, '  Segment: ', ItoH(seg(erroraddr^)));
    WRITELN(ErrFile, '  Offset:  ', ItoH(ofs(erroraddr^)));
    WRITELN_to_text(ErrFile, '------------------------------------------------');
    Close_text(ErrFile);
    if ShareInst = False then
      FileMode := 66;
{$IFNDEF MSDOS}
    FileModeReadWrite := FileMode;
{$ENDIF}
  end;
  ErrorAddr := nil;
  {be sure to uncomment this if using RipLink}
   {if RIP <> nil then
     Dispose(RIP, Done);}
end;

{$F-}

{$F+} procedure MyExit1; {$F-}
begin;
  TrapExit;
  SaveExitProc := Exitproc;
end;

end.
