Program Ustruct;
Uses Crt;
{USTRUCT.PAS  -- Revised 95-07-10   }
{-----------------------------------}
{Usurper v0.13 Data Files Structures}
{-----------------------------------}


{Run this program for a demonstration on how it can be used}

Const
 maxitem=15;     {maximum # of items a player can carry}
 maxspells=12;   {maximum # if spells available}

type
 s70 = string[70];
 s40 = string[40];
 s30 = string[30];

type
 ObjType = (Head,
            Body,
            Arms,
            Hands,
            Fingers,
            Legs,
            Feet,
            Waist,
            Neck,
            Face,
            Shield,
            Food,
            Drink,
            Weapon,
            Abody);

type
 Classes = (Alchemist,
            Assassin,
            Barbarian,
            Bard,
            Cleric,
            Jester,
            Magician,
            Paladin,
            Ranger,
            Sage,
            Warrior);

type
 Races = (Human,
          Hobbit,
          Elf,
          HalfElf,
          Dwarf,
          Troll,
          Orc,
          Gnome,
          Gnoll,
          Mutant);

type {Player/NPC Record}
 UserRec = record
 Name1 : string[30]; {user real name}
 name2 : string[30]; {user alias}
 ai    : char;       {'P' for player controlled, 'C' for computer controlled}
 race  : races;      {race}
 age   : integer;    {age}
 money : longint;    {money}
 hps   : longint;    {hitpoints}
 exp   : longint;    {experience}
 level : longint;    {level}
 bank  : longint;    {bank money}
 chiv  : longint;    {chivalry}
 dark  : longint;    {darkness}
 fights: integer;    {dungeon fights}
 strength : longint; {strength}
 defence  : longint; {general defence points}
 healing  : longint; {healing potions}
 allow   : boolean;  {allowed to play?}
 maxhps  : longint;  {maximum hitpoints}
 laston  : string[20];{last login date}
 ageplus : integer;   {counter to decide when it's time for birthday}
 darknr  : integer;   {dark deeds left}
 chivnr  : integer;   {good deeds left}
 anni    : integer;   {---works with ageplus-- don't mess with it}
 pfights : integer;   {player fights left}
 king    : boolean;   {king?}
 loc     : integer;   {location of player :
                        0 = dormitory (default)
                        1 = inn (downstairs)
                        2 = inn (first floor)
                        3 = inn (second floor)
                        4 = inn (third floor)
                        50= beggars wall}
 team    : string[40]; {name of team}
 teampw  : string[20]; {team password}
 teamrec : word;       {*not used right now*}
 bguard  : integer;    {type of doorguard hired at Inn}
 cturf   : boolean;    {is player team in control of town?}
 gnollp  : integer;    {if value >0 then player is poisoned by gnoll bite}
 mental  : integer;    {mental stability 1-100,  100 = perfect}
 addict  : integer;    {drug addiction,  1-100,  100 = heavy user}
 wellwish : boolean;   {have player visited wishing well}
 height   : integer;   {player height, in cm}
 weight   : integer;   {player weight, in kilos}
 eyes : integer;       {eye color}
 hair : integer;       {hair color}
 skin : integer;       {skin color}
 sex  : integer;       {gender 1=male, 2=female}
 mana : longint;       {mana, used by spellcasters}
 maxmana  : longint;   {maximum mana player can accumulate at current level}
 leader   : longint;   {*not used*}
 stamina  : longint;   {stamina}
 agility  : longint;   {agility}
 charisma : longint;   {charisma}
 dex      : longint;   {dexterity}
 wisdom   : longint;   {wisdom}
 weappow  : longint;   {weapon power}
 armpow   : longint;   {armor power}
 blind    : boolean;   {blind?}
 plague   : boolean;   {plague?}
 smallpox : boolean;   {smallpox?}
 measles  : boolean;   {measles?}
 leprosy  : boolean;   {leprosy?}
 mercy    : integer;   {*not used*}
 item     : array[1..maxitem] of integer;  {inventory}
 itemtype : array[1..maxitem] of objtype;  {inventory item type}
 phr      : array[1..6] of s70;            {different phrases}
 autoheal : boolean;   {buy healing potions after offline battle?}
 class    : classes;   {class}
 loyalty  : integer;   {team loyalty, only useful for NPCs}
 haunt    : integer;   {equals the # of demons that will jump player in dungeons}
 master   : char;      {level master '0'..'9'}
 tfights  : integer;   {team fights left}
 thiefs   : integer;   {thieving actions left}
 brawls   : integer;   {brawls left}
 assa     : integer;   {assasinations left}
 desc     : array[1..4] of s70; {character description}
 poison   : integer;   {>0 = poisoned}
 spell    : array[1..maxspells,1..2] of boolean; {spells available to player}
 skill    : array[1..14] of integer; {close combat skills}
 trains   : integer; {training sessions left}
 lhand    : word; {item in left hand    - only used in NEW mode}
 rhand    : word; {item in right hand   - only used in NEW mode}
 head     : word; {head armor           - only used in NEW mode}
 body     : word; {body armor           - only used in NEW mode}
 arms     : word; {arms armor           - only used in NEW mode}
 lfinger  : word; {item on left finger  - only used in NEW mode}
 rfinger  : word; {item on right finger - only used in NEW mode}
 legs     : word; {leg armor            - only used in NEW mode}
 feet     : word; {boots                - only used in NEW mode}
 waist    : word; {item around waist    - only used in NEW mode}
 neck     : word; {item around neck     - only used in NEW mode}
 neck2    : word; {item around neck     - only used in NEW mode}
 face     : word; {item on face         - only used in NEW mode}
 shield   : word; {shield               - only used in NEW mode}
 hands    : word; {item on hands        - only used in NEW mode}
 abody    : word; {item around body     - only used in NEW mode}
 immortal  : boolean; {never delete player because of inactivity?}
 battlecry : s70; {what player says when confronting opponent}
 bguardnr  : integer; {# of doorguards hired}
 casted    : boolean; {*flag used in battles*}
 punch     : longint; {*used to calculate strength in blow*}
 absorb    : longint; {*used to calculate armor absorbation*}
 used_item : boolean; {*temporary flag*}
 m_kills   : longint; {monster kills}
 m_defeats : longint; {monster defeats}
 p_kills   : longint; {player kills}
 p_defeats : longint; {player defeats}
 interest    : longint; {used to store accumulated bank interest}
 alive_bonus : longint; {used to store staying alive bonus}
 expert      : boolean; {expert menus?}
 maxtime     : integer; {maximum # of minutes the user has}
 ear         : byte; {set to 1..3, check what other nodes are doing}
 castin      : char; {*temporary flag used in battles*}
 weapon      : word; {weapon #,  only used in CLASSIC mode}
 armor       : word; {armor  #,  only used in CLASSIC mode}
 apow        : word; {armor power,  only used in CLASSIC mode}
 wpow        : word; {weapon power, only used in CLASSIC mode}
 disres      : byte; {disease resistance}
 amember     : boolean; {member of the alchemist society?}
 medal       : array[1..20] of boolean; {medals of honor}
 bankguard   : boolean; {is player working as bankguard?}
 bankwage    : longint; {salary from bank (guard duty)}
 weaphag     : byte; {# of times player has haggled in weaponshop}
 armhag      : byte; {# of times player has haggled in armorshop}
 filnr       : word; {file pointer, used when saving player}
 auto_meny   : boolean; {if TRUE then player wants menus displayed automatically}
end;


{---------------------------------------------
 Variables below are used by the DEMO program
----------------------------------------------}

const
      plyfil ='USERS.DAT';
      npcfil ='NPCS.DAT';
var
    i,y  : integer;
    ch,w : char;

    Player     : UserRec;
    PlayerFile : file of UserRec;    {** Userfile **}


Procedure Pause;
var s : string;
begin
 write('-Press Return-');
 readln(s);
end;

begin {--- DEMO Start ---}


 repeat
  Clrscr;
  writeln('');
  writeln('');
  writeln('Usurper - Structures - DEMO.');
  writeln('The MiniEditor');
  writeln('');
  writeln('L. Load Usurper player');
  writeln('Q. Quit this crap');
  write(':');

  ch:=upcase(readkey);

  case ch of
   'L':begin {load player}
        writeln('');
        write('Work with (P)layer or (N)pc file ? :');
        repeat
         ch:=upcase(readkey);
        until ch in ['P','N'];

        case ch of
         'P':begin
              w:='P';
              assign(playerfile,plyfil);
             end;
         'N':begin
              w:='N';
              assign(playerfile,npcfil);
             end;
        end;

        {$I-}
        reset(playerfile);
        {$I+}
        if IOresult<>0 then begin
         writeln('Error! Couldn''t access file : '+plyfil+'.');
         pause;
        end
        else begin
         writeln('');
         writeln('');
         y:=filesize(playerfile);

         for i:=1 to y do begin
          read(playerfile,player);
          if w='P' then writeln('Player #',i,' of #',y);
          if w='N' then writeln('NPC #',i,' of #',y);

          writeln('1. Real name : '+player.name1);
          writeln('2. Alias     : '+player.name2);
          writeln('3. Level     : ',player.level);
          writeln('4. Age       : ',player.age);

          write('[1..4], [N]ext, [Q]uit :');
          repeat
           ch:=upcase(readkey);
          until ch in ['1'..'4','N',chr(13),'Q'];

          writeln('');
          case ch of
           'Q': break;
           '1'..'4':begin
                     {implement your own stuff here...}
                     writeln('Oh no! Implement this yourself!');
                     writeln('I have already made my Usurper editor :)');
                     pause;
                    end;
          end;

         end;
         close(playerfile);
        end;
        ch:=' ';
       end;
  end;
 until ch='Q';


end.  {--- DEMO End ---}
