# Rooms for Forest of Fears
#
# -----------------------------------------------------------------------------

Name            Clearing
# teleport to another area when walking north
# $ means you need to have at least 1 life to go in, otherwise you are
# disallowed
Flags           FRI
North           $Random
Light           Outside
Description
|14Clearing
  |02You are in a clearing within a forest.  The trees surrounding this area
seem to prevent any one from leaving this clearing.  However, to the north,
you see a pulsating red light coming from between two trees.

  |11Remember this before going on:
|12  * |03Type out the direction letter to move (ex: N to move north)
|12  * |03Type A <demon> to attack a demon.
|12    -|03 Press A then [Enter] to attack a demon if there is only one demon
      in the room.
|12  * |03Type Z to repeat the last command (such as attacking)
|12  * |11Type WHO to see a listing of players in the game!

~
Script
 if (Lives = 0)
   :Loop
   out |03You have used up all your lives, please type |11QUIT |03to leave.
   wait 120
   wait 120
   goto Loop
 endif
~


Name            Rocks
East            DarkWoods.Entrance
North           Lake.Entrance
South           Field.Entrance
West            Cave.Entrance
Light           Outside
Description
|12Grouping of Rocks
  |04You see a strange arrangement of rocks in this area.  They seem to have
been made by primitive civilizations.
  |04You see a glistening lake to the north.  To the east, you see the entrance
to dark woods.  To the south, you see an open field.  To the west, you see
a cave entrance.
~

# ----------------------------------------------------------------------------
# DarkWoods
# ----------------------------------------------------------------------------

Name            DarkWoods.Entrance
West            Rocks
East            DarkWoods.Centre
Description
|12Dark Woods Entrance
  |05You are standing among a group of trees.  To the west, you can see several
large rocks erected in a pattern.  To the east, you see darker woods.
~

Name            DarkWoods.Centre
West            DarkWoods.Entrance
East            DarkWoods.E
North           DarkWoods.N
South           DarkWoods.S
Light           Outside
Description
|12Dark Woods
  |05You are within the middle of the woods known as The Dark Woods.  Far to the
west, you see can see a large grouping of rocks.  Immediately south is a small
pool of water.  To the east, you see large trees.  To the north, you see
several more trees.
~
Script
  wait 50
  out |12You hear an owl call.
  wait 100
  out |13Creatures begin to rustle the leaves around you.
~

Name            DarkWoods.N
South           DarkWoods.Centre
Up              DarkWoods.N.Tree
Light           Outside
Description
|12Several Trees
  |05You are among several trees.  As the wind blows, you can hear the calm
rustle of the trees.  And yet, you hear something more...
  To the south, you see more woods.  It looks as though you will be able to
climb a tree here.
~
Script
  wait 50
  out |03You hear the trees whispering something.
  wait 75
  out |09The trees continue to rustle.
~

Name            DarkWoods.N.Tree
South           DarkWoods.Centre.Tree
Down            DarkWoods.N
Light           Outside
Description
|12Atop a Tree
  |05You are standing on a large branch of a tree.  Down below, you see soft
ground on which you can jump.  To the south, you see another large tree which
you can jump to.
~
Script
  wait 50
  out |03The trees whisper in your ear.
  wait 75
  out |09You hear howling among the trees.
~

Name            DarkWoods.E
West            DarkWoods.Centre
Up              DarkWoods.E.Tree
Light           Outside
Description
|12Among Trees
  |05You are in a clearing where there are several huge trees.  They seem to
reach towards the heavens.  You see one that looks easy to climb.  To the
west, you see darker woods.
~

Name            DarkWoods.E.Tree
Down            DarkWoods.E
East            DarkWoods.E.Tree.Inside
Light           Outside
Description
|12Among Trees
  |05Standing on a large tree branch, below, you can see the forest floor.  To
the east, you see what looks to be an entrance to the tree.
~

Name            DarkWoods.E.Tree.Inside
West            DarkWoods.E.Tree
Down            DarkWoods.E.Tree.Inside.Down
Light           Inside
Description
|12Inside a Tree
  |05You are standing within a hollowed out tree.  To the west, you see the
outside world.  Down below, you see a small room.
~

Name            DarkWoods.E.Tree.Inside.Down
Up              DarkWoods.E.Tree.Inside
East            $Random
Light           Inside
Description
|12Inside a Tree
  |05You are standing inside a tree.  There are several small pieces of furniture
here.  To the east, you see a portal.  Above you, you can see more hollowed out
sections of the tree.
~

Name            DarkWoods.Centre.Tree
North           DarkWoods.N.Tree
Down            DarkWoods.Centre
Light           Outside
Description
|12Atop a Tree
  |05You are standing on several branches of a large tree.  Below, you can make
out the forest floor.  To the north, you can see another tree to which you can
jump.
~
Script
  wait 50
  out |03You think you hear the word "death" whispered by the trees.
~

Name            DarkWoods.S
North           DarkWoods.Centre
East            DarkWoods.Hut
Light           Outside
Description
|12A Pool of Water
  |05You are beside a small pool of water.  Strangely, you can see no signs of
a stream.  This area has a strange aura to it which makes you feel at home and
comfortable.  To the north, you see darker woods.  To the east, you see a small
hut.
~
Script
  wait 50
  out |11The trees around you have a healing property.  They make you feel better.
  GainHP 1
:Loop
  wait 75
  out |11The place soothes you and you feel better.
  GainHP 2
  wait 100
  out |11You feel even more relaxed.
  GainHP 2
goto Loop
~

Name            DarkWoods.Hut
West            DarkWoods.S
Down            DarkWoods.Hut.Hole
Light           Inside
Description
|13A Small Hut
  |05You are standing in a small hut.  It seems to have been abandoned.  You
see it has been left in a ramshackle state.  You see nothing of use for you
here.  There is a hole in the ground.
~

Name            DarkWoods.Hut.Hole
Up              DarkWoods.Hut
East            $Random
Light           Inside
Description
|13A Dark Room
  |05You are standing in a dark room.  There is no light at all, so you cannot
exactly tell what your surroundings hold.  However, above you, you see light
coming in from a room.  To the east, you see a pulsating light.
~

# ----------------------------------------------------------------------------
# Cave
# ----------------------------------------------------------------------------

Name            Cave.Entrance
East            Rocks
West            Cave.Hall
Light           Inside
Description
|13Entrance to a Cave
  |05You are within a cave entrance.  Torches the line the walls of this cave,
making it easy to see.  To the east, you can see a formation of rocks.  To
the west, the cave continues.
~

Name            Cave.Hall
East            Cave.Entrance
West            Cave.Corner
Light           Inside
Description
|13Within a Cave
  |05You are standing inside a cave.  Far to the east, you can see the cave's
entrance.  To the west, you see more cave!
~

Name            Cave.Corner
East            Cave.Hall
North           Cave.G
Light           Inside
Description
|13A Corner in a Cave
  |05You are standing in a small hallway of a cave.  To the east, you can see
light leading to the outside world.  To the north, you can see the cave
becoming larger.
~

Name            Cave.G
East            Cave.H
North           Cave.C
West            Cave.F
South           Cave.Corner
Light           Inside
Description
|13Within a Large Cave
  |05You are standing in a large cave.  You can see a small hallway within
the cave leading south.
~


Name            Cave.H
North           Cave.D
West            Cave.G
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.
~

Name            Cave.D
South           Cave.H
West            Cave.C
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.
~

Name            Cave.C
South           Cave.G
West            Cave.B
East            Cave.D
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.
~

Name            Cave.B
South           Cave.F
West            Cave.A
East            Cave.C
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.
~

Name            Cave.A
South           Cave.E
East            Cave.B
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.
~

Name            Cave.E
South           Cave.I
East            Cave.F
North           Cave.A
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.  To the south, you see a small hallway.
~

Name            Cave.F
North           Cave.B
East            Cave.G
West            Cave.E
Light           Inside
Description
|13Within a Cave
  |05You are standing in a large cave.  To the south, you see a small hallway.
~

Name            Cave.I
North           Cave.E
South           Cave.J
Light           Inside
Description
|13A Cave Hallway
  |05You are standing inside a hallway within a cave.  The hallway extends to
the south and leads to a larger cavern to the north.
~

Name            Cave.J
North           Cave.I
East            Cave.K
Light           Inside
Description
|13A Cave Hallway
  |05You are standing in a hallway within a cave.  The hallway bends here so
it leads north to a longer hallway and east to a small area.
~

Name            Cave.K
West            Cave.J
Light           Inside
Description
|13Small Area of a Cave
  |05You are in a small area of a cave.  The ceiling here is very low, so you
must duck.  To the west, you see a hallway.
~

# ----------------------------------------------------------------------------
# Field
# ----------------------------------------------------------------------------

Name            Field.Entrance
South           Field.B
North           Rocks
Light           Outside
Description
|12A Field
  |03You are standing in a narrow area where trees line the east and west sides
of a small path.  To the north, you can see rocks.  To the south is a large
field.
~

Name            Field.A
East            Field.B
South           Field.E
Light           Outside
Description
|12A Field
  |03You are standing in the corner of a large square-shaped field.  Large trees
line the edges of the field.  To the east and south, the field continues on.
~

Name            Field.B
North           Field.Entrance
South           Field.F
East            Field.C
West            Field.A
Light           Outside
Description
|12A Field
  |03You are standing in the norther half of a large square-shaped field.  To
the north, you see a small path leading to some rocks.  The field continues
around you to the south, east and west.
~


Name            Field.C
South           Field.G
West            Field.B
Light           Outside
Description
|12A Field
  |03You are standing in the corner of a large square-shaped field.  Large trees
line the edges of the field.  To the west and south, the field continues on.
~

Name            Field.D
East            Field.E
Light           Outside
Description
|12A Field
  |03You are standing on the far western edge of a large square-shaped field.
The field continues on to the east.
~

Name            Field.E
South           Field.I
East            Field.F
West            Field.D
North           Field.A
Light           Outside
Description
|12A Field
  |03You are standing near the edge of a large square-shaped field.  Large trees
line the edges of the field.  To the north, south, and west, the field
continues on for a short distance.  To the east, it continues far.
~


Name            Field.F
South           Field.J
East            Field.G
West            Field.E
North           Field.B
Light           Outside
Description
|12A Field
  |03You are standing in the center of a large field.  The field continues
far to the north, south, east, and west.
~


Name            Field.G
South           Field.K
East            Field.H
West            Field.F
North           Field.C
Light           Outside
Description
|12A Field
  |03You are standing near the edge of a large square-shaped field.  Large trees
line the edges of the field.  To the east, you can see the edge of the field.
To the north, south, and west, you see the field continuing.
~

Name            Field.H
West            Field.G
Light           Outside
Description
|12A Field
  |03You are standing on the eastern edge of a large square-shaped field.
line the edges of the field.  The field continues on far to the west.
~


Name            Field.I
Down            Beach
East            Field.J
North           Field.E
Light           Outside
Description
|12A Field
  |03You are standing in the corner of a large square shaped field.  Large trees
line the edges of the field.  To the north and east, the field continues on.
There is a cliff here which leads down to a small beach.
~

Name            Field.J
Down            Beach
East            Field.K
West            Field.I
North           Field.F
Light           Outside
Description
|12A Field
  |03You are standing on the southern edge of a large field.  To the north,
east, and west, the field continues on.  There is a cliff here which leads
down to a small beach.
~

Name            Field.K
Down            Beach
West            Field.J
North           Field.G
Light           Outside
Description
|12A Field
  |03You are standing in the corner of a large square shaped field.  Large trees
line the edges of the field.  To the north and west, the field continues on.
There is a cliff here which leads down to a small beach.
~

Name            Beach
Up              Field.J
Light           Outside
Description
|14A Beach
  |06You are standing on a small beach.  Up above, you see a some climbable rocks
leading to a cliff.
~

# ----------------------------------------------------------------------------
# Lake
# ----------------------------------------------------------------------------

Name            Lake.Entrance
North           Lake.I
South           Rocks
Light           Outside
Description
|09Lake Entrance
  |03You are standing in front of a fresh-water lake.  To the south, you see
rocks lake and to the north is the lake.
~


Name            Lake.A
Domains         L
South           Lake.C
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  To the south, you see more lake.
~

Name            Lake.B
Domains         L
East            Lake.C
South           Lake.F
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  To the south, you see more lake
as well as to the east.
~

Name            Lake.C
Domains         L
North           Lake.A
West            Lake.B
South           Lake.G
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  To the south, you see more lake.
To the west, you see more lake!  To the north, the lake stops somewhat.
~

Name            Lake.D
Domains         L
East            Lake.E
South           Lake.H
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the east.
To the south, you can see some more lake.
~

Name            Lake.E
Domains         L
East            Lake.F
West            Lake.D
South           Lake.I
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the east
and a short distance to the west.  To the south, you can see rocks far away.
~


Name            Lake.F
Domains         L
North           Lake.B
East            Lake.G
West            Lake.E
South           Lake.J
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the west
and a short distance to the east.  To the south, you can see the the lake
becomes more shallow.
~


Name            Lake.G
Domains         L
North           Lake.C
West            Lake.F
South           Lake.K
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the west.
You see that you can swim further north and south.
~

Name            Lake.H
Domains         L
East            Lake.I
North           Lake.D
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the east
and a short distance to the north.
~

Name            Lake.I
Domains         L
West            Lake.H
East            Lake.J
North           Lake.E
South           Lake.Entrance
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the east
and a short distance to the west.  To the south, you can see rocks far away.
You see more lake to the north as well.
~

Name            Lake.J
Domains         L
West            Lake.I
East            Lake.K
North           Lake.F
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the west
and a short distance to the east.  To the north, the lake extends as well.
~


Name            Lake.K
Domains         L
West            Lake.J
North           Lake.G
Light           Outside
Description
|09A Lake
  |03You are swimming in a fresh-water lake.  The lake extends far to the west.
To the north, the lake extends as well.
~
