Program Hangman;
{
        Hangman Door - Oct 7 / 1997

Last Updated:
    September 2 2007 - Added score display (/S and /T for top ten)
    Sometime in 2007 to port back to Edoor.
    June 23 2005 Linux / Xdoor ports.

BUGS:

TODO:
* Number of plays/tuens
? Time per Word/Game

IBBS:
- Send file with *.MSG attach mess. (BLANK!)
- Command line switches:
  - /IN
  - /OUT
  - /ALL - /NIGHTLY (whatever)
- Seperate score file name for IBBS mode ...? Integrate 'em???
- Hub of IBBS reg'd?? (Later?)
- BBS name in score file (How to display?)
- Seperate util for host.

DONE (Ver 1.5):
- Last months top ten SHOULD work properly now (Need to test)
- If there are only enough scores to fill one page, it won't scroll to
  second screen anymore.
}
// {$DEFINE MSDOS}

uses
{$IFDEF LINUX}
  locald,
  Enigma,
{$ENDIF}
{$IFDEF MSDOS}
  door,
{$ENDIF}
{$IFDEF OS2}
  door2,
  StrStf,
{$ENDIF}
{$IFDEF WIN32}
  Door2,
  Strstf,
{$ENDIF}
  DSpin,
  TnyHang,
  dos,
  crt;

type
  rec_type=Record               { Begin word file struct         }
    word:string[15];            { Word (15 chars)                }
    hint:string[50];            { Hint (50 chars)                }
  end;                          { End word file struct           }
  score_type=Record             { Begin score file struct        }
    scorename: String[25];      { Users name                     }
    scorepoints: LongInt;       { Users points                   }
    numofplays: Longint;        { Stored # of plays remaining    }
    d: Longint;                 { Day user last played (DD)      }
    m: Longint;                 { Month user last played (MM)    }
    y: Longint;                 { Year user last played (YYYY)   }
    hour: Longint;              { Hour user last played (24 Hr.) }
    min: Longint;               { Minute user last played        }
  end;                          { End score file struct          }
  old_scores=record             { Begin oldscores struct         }
    Month: Longint;             { Month old score last processed }
    Name: array [1..10] of String;   { Player's Name             }
    Score: array [1..10] of Longint; { Player's Score            }
  end;                          { End oldscores struct           }

const
  alphabet: array [1..26] of Char=('A','B','C','D','E','F','G','H','I','J',
                                   'K','L','M','N','O','P','Q','R','S','T',
                                   'U','V','W','X','Y','Z');
var
{$IFDEF MSDOS}
  Hour, Min, Sec, Hund: Word;
  y, m, d, dow: Word;
{$ELSE}
(* If you are using FPC to compile under Linux un comment the below lines.
   as FPC needs these to be words, and VP needs LongInts.
    {$IFDEF LINUX}
    Hour, Min, Sec, Hund: Word;
    y, m, d, dow: Word;*)
(*  {$ELSE} *)
  Hour, Min, Sec, Hund: Longint;          { Time Routine                  }
  y, m, d, dow: LongInt;
{$ENDIF}
  sf: File of Score_Type;                 { Score File                    }
  score: Score_Type;                      { Score record                  }
  score1: Integer;                        { Working score int             }
  rec: rec_type;                          { Dat file structs.             }
  word:array[1..15] of String[1];         { Word, subdivided to 15 letters}
  alpha:array[1..27] of boolean;          { 'Bet                          }
  time:array[1..15] of integer;           { Has letter[x] been used?      }
  miss, pick: Integer;                    { Who the hell knows...         }
  allowadd: Boolean;                      { Allow users to add words?     }
  fv:file of rec_type;                    { Word file                     }
  quit: Boolean;                          { Boolean for Quit game         }
  TheErrCode: Byte;                       { Error Code for FRename        }
  NumOfPlays: Integer;                    { Number of plays               }
  Nop: Integer;                           { Ditto, but constant           }
  Ag: Boolean;                            { Temp Bool.                    }
  Logpath: String[79];                    { Filename of Logfile           }
  Tempoint: Integer;                      { Temp int for Bubblesort       }
  {$IFDEF OS2}
  tscore: array [1..1000] of score_type;  { Array used to BSort scores    }
  {$ELSE}
  tscore: array [1..500] of score_type;   { Array used to BSort scores    }
  {$ENDIF}
  Oldscore: file of old_scores;           { Last month top 10 score file  }
  OScore: old_scores;                     { Record of old scores          }
  TimeAmount: String[4];                  { Amount of time for timelimit  }
  FirstPlay: Boolean;                     { Is it their first play today? }

Procedure ReadTheConfig;
var
  i: Integer;
  S: String[1];                           { Bullshit string               }
  F2: Text;                               { Config file                   }
  line1: String[5];                       { Allow users to add words?     }
begin
  Assign(F2, 'thang.cfg');
  reset(F2);
  for i:= 1 to 5 do Readln(F2, S);
  readln(F2, line1);                      { Allow users to add words?     }
  readln(F2, Nop);                        { # of plays, -1 is unlimited   }
  readln(F2, Logpath);                    { Logfile path, NONE disables   }
  readln(F2, TimeAmount);                 { Max. seconds per letter       }
  if StoI(TimeAmount) <= 0 then TimeAmount := '0';
  close(F2);
  if line1 = 'TRUE' then AllowAdd := True else AllowAdd := False;
end;

Procedure NewUser;
begin
  Assign(SF, 'scores.dat');
  Reset(SF);
  score.scorename := userh;
  score.scorepoints := 0;
  score.numofplays := Nop;
  seek(sf,filesize(sf));              {Go to end of file}
  write(sf,score);                    {Write name and 0 score}
  close(sf);
  NumOfPlays := Nop;
end;

procedure Switch(var one,two: score_type);
var   { Switch one with two, used by bubblesort }
  k: score_type;
begin
  k := one;
  one := two;
  two := k;
end;

procedure DoOldScores;
var
  i,j: Integer;
begin
  Assign(Oldscore, 'OLDSCORE.DAT');
  {$I-}Reset(Oldscore);{$I+}
  if IOResult <> 0 then                 {Oldscores file doens't exist}
  begin
    Rewrite(Oldscore);                  {Create it}
    getdate(y,m,d,dow);
    OScore.Month := m;                  {Write the month (To be used next }
    Write(Oldscore, OScore);            { month)}
    Close(Oldscore);                    {There was no last month, so don't }
    Exit;                               { need to process!}
  end else
  begin
    Read(OldScore, OScore);             {Read last month's data to mem}
    Close(Oldscore);
    getdate(y,m,d,dow);
    if OScore.month <> m then           {If this month <> month in file}
    begin
      Fillchar(Oscore, SizeOf(OScore), 0);
      Assign(Sf, 'SCORES.DAT');
      Reset(sf);
      if Filesize(SF) = 0 then
      begin
        Close(SF);
        delfile('scores.dat');
        Exit;
      end;
      Tempoint := 1;                    {Sorting scores from here to ... }
      while not Eof(sf) do
      begin
        read(sf, tscore[Tempoint]);
        Inc(Tempoint);
      end;
      Close(sf);
      Dec(Tempoint);
      for i := 1 to Tempoint do
        for J := Tempoint downto i do
          if tscore[j - 1].scorepoints > Tscore[j].scorepoints then
            Switch(Tscore[j], Tscore[j - 1]);
      j := 1;
      repeat
        OScore.Name[j] := tscore[Tempoint].scorename;
        OScore.Score[j] := tscore[Tempoint].scorepoints;
        Inc(j);
        Dec(Tempoint);
      until (j = 10) OR (Tempoint = 0); { ... Here! }
      Assign(Oldscore, 'OLDSCORE.DAT');
      ReWrite(Oldscore);                {Writing this month to the file}
      OScore.Month := m;                {Save this month}
      Write(Oldscore, Oscore);          {Write the bloody thing}
      Close(Oldscore);
      Delfile('Scores.dat');            {And start a new month from scratch!}
    end;
  end;
end;

procedure Startup;
var
  isnew: Boolean;                       {Is this a new user}
begin
  if exist('scores.dat') then           {Need this month to get have last month!}
    DoOldScores;                        {Do last months top 10 (if needed)}
  Assign(SF, 'scores.dat');
  {$I-}
  Reset(SF);
  {$I+}
  if (IOResult = 0) AND (Filesize(SF) > 0) then
  begin                                 {Score file is here}
    isnew := True;
    while not eof(sf) do
    begin
      read(sf,score);
      if userh = score.scorename then   {Stop when user is found}
      begin
        isnew := False;                 {Woah! Users in the file not new}
        Break;
      end;
    end;
  Close(sf);
  end else
  begin
    Assign(SF, 'scores.dat');         {Write it}
    rewrite(sf);
    isnew := True;                    {Yep he's a new user}
    Close(sf);
  end;
  getdate(y,m,d,dow);
  if (score.y = y) AND (score.m = m) AND (score.d = d) then
    {They've played already today - get numofplays from file}
    NumOfPlays := score.numofplays
  else
    {Hasn't played today - Get numofplays from config file}
    NumOfPlays := Nop;
  If NumOfPlays < -1 then NumOfPlays := Nop; {Be sure Nop doesn't get too low}
  if isnew = True then Newuser;
  FirstPlay := TRUE;
end;

Procedure DataFile;
var
  tempi: Integer;
begin
  tempi := 0;
  Assign(SF, 'scores.dat');
  Reset(Sf);
  while not eof(sf) do
  begin
    read(sf,score);
    if userh = score.scorename then
    begin
      if tempi > 0 then
      begin
        if miss = 0 then tempi := tempi + score.scorepoints + score1 + 5
        else tempi := tempi + score.scorepoints + score1;
      end else
        if miss = 0 then tempi := score.scorepoints + score1 + 5
      else tempi := score.scorepoints + score1;    {Score in file plus this 1}
      Break;
    end;
  end;
  Seek(sf,filepos(sf) - 1);                      {End of temp file}
  score.scorename := userh;
  score.scorepoints := tempi;                     {Totaled Score}
  score.numofplays := NumOfPlays;
  if score.scorepoints > 0 then Write(sf,score);  {Write updated score to file}
  close(sf);
end;

procedure EndExit;                      {End the door}
begin
  quit := True;                         {Yup, I'm sure}
  window(1,1,80,25);                    {Clear everything}
  fg(7);
  DClrScr;
  DPipe('|12R|04eloading |15');
  DPipe(bbsname);                       {Edoor - Name of BBS}
  DPipeLn('|12 .|04.|12.|04.|12.|04.');
  DCRlf; DCrlf;
end;

function NoASCII(ThisWord: String): Boolean;
var
  AnInt: Integer;
begin
  NoAscii := TRUE;
  For AnInt := 1 to length(ThisWord) do
  begin
    {If the word isn't A..Z}
    if not (Ord(ThisWord[AnInt]) in [65..90,32]) then
    begin
      {There's ASCII crap in the word}
      NoASCII := FALSE; {So don't allow it!}
      Exit;             {Already found ASCII, no need to continue}
    end;
  end;
end;

Procedure AddAWord;
const
  days:array [0..6] of String[4] = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
  month:array [1..12] of String[4] = ('Jan','Feb','Mar','Apr','May','Jun',
                                      'Jul','Aug','Sep','Oct','Nov','Dec');
var
  Time,                   { Time string for log }
  Date: String[50];       { Date string for log }
  Log: Text;              { Logfile             }
  s: String;              { Temp Hint string    }
  singword: String;       { Temp Word string    }
  bo: Boolean;            { Standard Boolean    }
Begin
  DClrScr;
  TnyBorderDisp;
  Header;
  rec.word:='';
  rec.hint:='';
  assign(fv,'words.dat');               {Let's open the word file}
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then
  begin
    assign(fv,'words.dat');
    rewrite(fv);                        {Hmm, No file, we'll make one}
  end else seek(fv,filesize(fv));       {Found it!}
  DGotoXY(3,10);
  DPipe('|12E|04nter |12a n|04ew |12w|04ord |15(|07Max |1115 |07Character|15): ');
  Inpt(singword, 15, 11, 1);
  singword := StrUpcase(singword);        {Convert word to UPCASE}
  if Length(singword) <= 2 then           {If word is 2 chars or less long}
  begin                                   {Abort - Don't add B.S. word!}
    close(fv);
    Exit;
  end;
  if not NoASCII(Singword) then
  begin
    DGotoXY(3,12);
    DPipe('|12Y|04ou |12m|04ay |12o|04nly |12u|04se |12t|04he |12l|04etters |12A |07- |12Z i|04n |12y|04our |12w|04ord|07.');
    Assign(Log, Logpath);
    {$I-}
    Append(Log);
    {$I+}
    if IOResult <> 0 then
    begin
      Rewrite(Log);
      WriteLn(Log);
      WriteLn(Log, Center(doorname)); {Tell what the hell this log is}
      WriteLn(Log);
    end;
    getdate(y,m,d,dow);
    gettime(Hour, Min, Sec, Hund);
    Date := Days[dow] + ' ' + Month[m] + ' ' + ItoS(D) + ' ' + ItoS(Y) + ' ';
    Time := LeadingZero(Hour) + ':' + LeadingZero(Min) + ':' + LeadingZero(Sec) + ' - ';
    WriteLn(Log, Date + Time + Userh + ' Attempted to add word: ' + singword);
    WriteLn(Log, Date + Time + 'Word not accepted.');
    Close(Log);
    Close(fv);
    Delay(1000);
    Exit;
  end;
  DGotoXY(3,12);
  DPipe('|12E|04nter |12t|04he |12h|04ints |15(|07Max |1150 |07Characters|15): ');
  DGotoXY(3,13);
  Inpt(s, 15, 11, 1);
  if Length(s) <= 4 then
  begin
    if Filesize(fv) = 0 then delfile('words.dat'); {If they didn't add word}
    Exit;             {Kill file to avoid errors later}
  end;
  rec.hint := s;
  rec.word := singword;
  DGotoXY(3,15);
  DPipe('|12Y|04ou |12e|04ntered|07: |15');
  DPipe(rec.word);
  DGotoXY(3,16);
  DPipe('|12W|04ith |12a h|04int |12o|04f|07: |15');
  DPipe(rec.hint);
  DGotoXY(3,18);
  bo:=tdynlb('Save? ', '|18|12 Yes |16 |01no ', '|16|01 yes |17 |12No |16');
  if bo = True then {If they choose to save}
  begin
    Write(fv,rec);
    close(fv);
    if StrUpcase(Logpath) <> 'NONE' then
    begin
      Assign(Log, Logpath);
      {$I-}
      Append(Log);
      {$I+}
      if IOResult <> 0 then
      begin
        Rewrite(Log);
        WriteLn(Log);
        WriteLn(Log, Center(doorname)); {Tell what the hell this log is}
        WriteLn(Log);
      end;
      getdate(y,m,d,dow);
      gettime(Hour, Min, Sec, Hund);
      Date := Days[dow] + ' ' + Month[m] + ' ' + ItoS(D) + ' ' + ItoS(Y) + ' ';
      Time := LeadingZero(Hour) + ':' + LeadingZero(Min) + ':' + LeadingZero(Sec) + ' - ';
      WriteLn(Log, Date + Time + Userh + ' Added word: ' + singword);
      WriteLn(Log, Date + Time + 'With a hint of: ' + s);
      Close(Log);
    end;
  end else
  if bo = False then {User doesn't want to save}
  begin
    DGotoXY(3,20);
    DPipeLn('|12Y|04ou |12c|04hose |14not |12t|04o |12s|04ave|15.');
    DGotoXY(1,23);
    HitEnter;
    if Filesize(fv) = 0 then delfile('words.dat');
  end;
End;

function PlayAgain: Boolean;
begin
  {Make sure they still have plays left for today}
  If NumOfPlays = 0 then
  begin
    DGotoXY(2,23);
    DPipe('|12S|04orry|07, |12b|04ut |12y|04ou |12a|04re |12o|04nly |12a|04llowed |07');
    DPipe(ItoS(NOP));
    DPipe(' |12P|04lays |12P|04er |12d|04ay|07. |12P|04lease |12p|04lay |12a|04gain |12t|04omorrow|07.');
    HitEnter;
    PlayAgain := FALSE;
    Ag := FALSE;
    Exit;
  end else PlayAgain := TRUE;
end;

Procedure TimeUp(var Thevar: Char);
var
  Thedelay,             {For keeping track of the delay}
  Pause,                {The length of each delay 'chunk' (of 5)}
  Thex: Integer;        {The 'Y' position}

  function ATOZ: Boolean;
  var
    Anothertemp: Integer;    {A temp int}
  begin {ATOZ}
    {$IFDEF LINUX}
    if Keypressed then
    {$ELSE}
    if Dkeypressed then
    {$ENDIF}
    begin
      DreadC(Thevar);
      Thevar := Upcase(Thevar);
      Anothertemp:=ord(Thevar)-64;
      {If key is A..Z but not picked before}
      if ((Thevar in ['A'..'Z']) AND (not Alpha[Anothertemp])) then
        ATOZ := TRUE else ATOZ := FALSE;
    end else ATOZ := FALSE;
  end; {ATOZ}

begin {TimeUp}
  Pause := (StoI(TimeAmount) * 1000) div 10;
  DGotoXY(10,16);
  DPipe('|04Time Left:');
  for Thex := 10 to 19 do
  begin
    DGotoXY(Thex,17);
    DPipe('|01'); {ASCII # 220}
  end;
  DGotoXY(Thex - 1, 17);
  Thex := 19;
  Thedelay := 100;
  repeat
    Delay(100);
    if Thedelay >= Pause then
    begin
      Thedelay := 100;
      DGotoXY(Thex, 17);
      DPipe('|08');
      DGotoXY(Thex - 1, 17);
      Dec(Thex);
      if Thex = 9 then
      begin
        Thevar := #0;
        DGotoXY(Thex + 1, 17);
        Delay(200);
        Exit;
      end;
    end;
    Inc(Thedelay, 100);
  until ATOZ;
end; {TimeUp}

Procedure Firsttime;
begin
  Assign(SF, 'scores.dat');
  Reset(SF);
  While not Eof(SF) do
  begin
    read(SF,score);
    if Userh = score.scorename then Break;
  end;
  GetDate(y,m,d,dow);
  score.m := m;
  score.d := d;
  score.y := y;
  Gettime(hour,min,sec,hund);
  score.hour := hour;
  score.min := min;
  score.numofplays := Numofplays;
  Seek(sf,filepos(sf) - 1);
  Write(SF, score);
  Close(SF);
  FirstPlay := FALSE;
end;

Procedure PlayTheGame;
var
  sel: Char;
  i,
  refer,
  guess:integer;
  mistake:boolean;                        { Did the user make a mistake?  }
  again: Char;                            { Play again? Y/N               }
  s1: String[15];                         { Whole Word                    }
Begin
  if FirstPlay then Firsttime;
  DClrScr;
  TnyBorderDisp;
  DGotoXY(31,22);
  DPipe('|12C|04urrent |12s|04core|07: ');
  DPipe(ItoS(score.scorepoints));      {Put their score on the screen}
  assign(fv,'words.dat');               {Open the word file}
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then
  begin
    Header;
    DGotoXY(30,13);
    DPipe('|14NO |11words in database|15!!!|07');
    DGotoXY(1,23);
    HitEnter;
    AG := FALSE;                        {They don't want to play again}
    Exit;                               {Back to main menu}
  end;
 randomize;
 pick:=random(filesize(fv));            {Picks a random number}
 seek(fv,pick);                         {Go to random record in file}
 read(fv,rec);                          {read it into memory}
 close(fv);                             {I'm done, close the file}
 guess:=0;
 miss:=0;
 For i:=1 to 26 do alpha[i]:=false;
 For i:=1 to 15 do time[i]:=0;
 Header;                               {Print the header to screen}
 s1:=rec.word;
 fg(12);
 DGotoXY(14,9);
 DPipe('Hint: ');
 DPipe(rec.hint);
 For i:=1 to 26 do
 Begin
   fg(2);
   DGotoXY(i*2+12,12);
   DPipe(alphabet[i]);    {Write the 'bet to the screen}
 end;
 pole;                                  {Draw the pole}
 for i := 1 to length(s1) do Word[i] := s1[i];
 For i := 1 to length(s1) do
 Begin
   fg(14);
   DGotoXY((42-length(s1))+(i-1)*2,10);
   If Ord(S1[i]) <> 32 then DPipe('_') else Inc(Guess);
   score1 := (length(s1));   {Set the Total points for this Word}
 end;                        {Number of letters in the word is score}
 Repeat
   Repeat
     {If they have a timelimit, read the key with Timeup}
     if StoI(Timeamount) > 0 then Timeup(sel) else
     begin
       DreadC(sel);
       sel := Upcase(sel);
     end;
   Until (ord(sel)>64) and (ord(sel)<91) and (alpha[ord(sel)-64]=false) OR (sel = #0);
  if sel <> #0 then
  begin
  {If they didn't run out of time}
    refer:=ord(sel)-64;
    DGotoXY((refer*2)+12,12);
    fg(4);
    DPipe(alphabet[refer]);
  end else
  begin
  {If they ran out of time}
    refer := 27;
    Alpha[refer] := FALSE;  {Refer 27 is a dummy for use with the mistakes}
  end;
  mistake:=true;
 For i:=1 to length(s1) do
 Begin
   If sel=word[i] then
   Begin
     DGotoXY((42-length(s1))+(i-1)*2,10);
     If time[i]=0 then
     Begin
       fg(14);
       DPipe(word[i]);
       DGotoXY((refer*2)+12,12);
       inc(time[i]);
       inc(guess);
       Alpha[refer] := True;
     End;
    DGotoXY((refer*2)+12,12);
    fg(14);
    DPipe(alphabet[refer]);
    mistake:=false;
    End;
  End;
  If (mistake=true) and (alpha[refer]=false) then
   Begin                                     {user hit letter not in word}
    inc(miss);
    alpha[refer]:=true;
    fg(4);
    Case miss Of
    1:Begin
      DGotoXY(41,17);DPipe('0');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    2:Begin
      DGotoXY(41,18);DPipe('|');
      DGotoXY(41,19);DPipe('^');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    3:Begin
      DGotoXY(40,17);DPipe('\');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    4:Begin
      DGotoXY(42,17);DPipe('/');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    5:Begin
      DGotoXY(40,19);DPipe('/');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    6:Begin
      DGotoXY(42,19);DPipe('\');
      if score1 > 0 then
        dec(score1)                      {Take 1 point away}
      else
      if score1 <= 0 then
        score1 := 0;
      End;
    7:Begin
      score1 := 0;
      fg(4);
      DGotoXY(41,17);DPipe(chr(1));
       For i:=14 to 39 do
        Begin                   {Didn't guess the word Kill user and display}
         fg(random(15)+1);      {The correct answer}
         DGotoXY(i,21);DPipe('A');
         delay(20);
        End;
       For i:=40 to 62 do
       Begin
        fg(random(15)+1);
        DPipe('H');
        delay(20);
       End;
       DPipe('!!');
       DGotoXY(14,14);
       DPipe('|07Correct Answer is: |10');
       DPipe(S1);
      End;
   End;
 End;
 Until (guess=length(s1)) or (miss=7);
 If guess=length(s1) then
   Begin
    For i:=40 to 52 do
    Begin
      fg(random(15)+1);
      men1(i,17);delay(80);men2(i,17);delay(80);
      DGotoXY(i,17);DPipe(' '); DGotoXY(i,18);DPipe(' ');
      DGotoXY(i,19);DPipe(' ');
      delay(10);
    End;
    For i:=52 downto 40 do
    Begin
      fg(random(15)+1);
      men1(i,17);delay(80);men2(i,17);delay(80);
      DGotoXY(i+2,18);DPipe(' ');
      DGotoXY(i+2,19);DPipe(' ');
      delay(10);
    End;
  end;
  men1(40,17);
  Dec(NumOfPlays);
  Assign(SF, 'scores.dat');
  {$I-} Reset(SF); {$I+}
  if ioresult <> 0 then
  begin                                   {This one is creating the}
    Assign(sf, 'scores.dat');             { file, so no need to check}
    rewrite(sf);                          { For previous records etc.}
    score.scorename:=userh;
    if miss = 0 then
      score.scorepoints:=score1 + 5
    else
      score.scorepoints:=score1;
    GetDate(y,m,d,dow);
    score.m := m;
    score.d := d;
    score.y := y;
    GetTime(hour,min,sec,hund);
    score.hour := hour;
    score.min := min;
    if score.scorepoints <> 0 then
      Write(sf,score);
    close(sf);
  end else DataFile;   {This one needs to check, Goes to Datafile procedure}
  DGotoXY(31,22);
  DPipe('|12C|04urrent |12s|04core|07: ');
  DPipe(ItoS(score.scorepoints));      {Put their score on the screen}
  DGotoXY(14,23);
  DPipe('|12W|04ant |12t|04o |12t|04ry |12a|04gain|15? (|12Y|15/|12N|15)|07:');
  repeat
    again:=readkeyspin(40);
  until upcase(again) in ['Y','N'];
  case upcase(again) of
    'Y': Ag := TRUE;  {Ag := True so restart}
    'N': Ag := False; {Ag := False so DON'T restart}
  end;
End;

Procedure DisplayScore;
var
  ch: Char;                             {Char for Enter Shit}
  icount,                               {count what score I'm displaying}
  icount2: Integer;                     {Line to display on}
  i,j: Integer;
  hour: String[2];
begin
  DClrScr;
  TnyBorderDisp;
  DGotoXY(9,4);
  DPipe('|10Player Name                  |09Score       |11Date       |14Time');
  DGotoXY(8,5);
  DPipe('|13-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  icount := 0;
  icount2 := 7;
  Assign(SF, 'scores.dat');
  Reset(SF);
  Tempoint := 1;
  while not Eof(sf) do            {Sort the scores in the array Tscore}
  begin                                                              {}
    read(sf, tscore[Tempoint]);                                      {}
    Inc(Tempoint);                                                   {}
  end;                                                               {}
  Dec(Tempoint);                                                     {}
  for i := 1 to Tempoint do                                          {}
    for J := Tempoint downto i do                                    {}
      if tscore[j - 1].scorepoints > Tscore[j].scorepoints then      {}
        Switch(Tscore[j], Tscore[j - 1]);                  {'Till here}
  for i := Tempoint downto 1 do
  begin
    if (icount2 > 18) AND (Tempoint > 1) then  {If it gets past line 18}
    begin
      DGotoXY(8,20);
      DPipe('|13-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      DGotoXY(1,23);
      DPipe(Center('|15(|12N|15)|04ext |15 / (|12Q|15)|04uit|07:'));
      repeat
        Ch := Upcase(ReadkeySpin(40));
      until Ch in ['N','Q',#13];
      if Ch = 'Q' then Exit;
      DClrScr;
      TnyBorderDisp;
      DGotoXY(9,4);
      DPipe('|10Player Name                  |09Score       |11Date       |14Time');
      DGotoXY(8,5);
      DPipe('|13-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
      icount2 :=7;
    end;
    if Tscore[i].scorepoints > 0 then
    begin
      DGotoXY(9,icount2);
      fg(10);
      DPipe(Tscore[i].scorename);         {Write The name from memory}
      DGotoXY(38,icount2);
      fg(09);
      DPipe(ItoS(Tscore[i].scorepoints)); {Write the points to screen}
      DGotoXY(50,icount2);
      fg(11);
      DPipe(LeadingZero(Tscore[i].m));
      DPipe('/');
      DPipe(LeadingZero(Tscore[i].d));
      DPipe('/');
      DPipe(LeadingZero(Tscore[i].y));
      DPipe(' ');
      Fg(14);
      if Tscore[i].hour > 12 then hour := ItoS(TScore[i].hour - 12)
      else if Tscore[i].hour = 0 then hour := '12'
      else hour := ItoS(Tscore[i].hour);
      If Length(hour) = 1 then DPipe(' ' + hour)
      else DPipe(hour);
      DPipe(':');
      DPipe(LeadingZero(Tscore[i].min) + ' ');
      if Tscore[i].hour > 11 then DPipe('PM') else DPipe('AM');
      Inc(Icount);
    end;
    Inc(Icount2);
  end;
  close(sf);
  DGotoXY(8,20);
  DPipe('|13-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  DGotoXY(1,23);
  HitEnter;
end;

Procedure TopTen;
var
  Line: Integer;
  Place: Integer;
begin
  if not exist('oldscore.dat') then Exit;
  Line := 8;
  DClrScr;
  TnyBorderDisp;
  DGotoXY(9,3);
  DPipe('|15Last Months Top Ten Scorers:');
  DGotoXY(9,5);
  DPipe('|15#   |04Player Name                  |07Score');
  DGotoXY(8,6);
  DPipe('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  Assign(Oldscore, 'oldscore.dat');
  Reset(Oldscore);
  Read(Oldscore, OScore);
  Close(Oldscore);
  for Place := 1 to 10 do
  begin
    DGotoXY(9,Line);
    fg(15);
    DPipe(ItoS(Place));
    DGotoXY(13,Line);
    fg(4);
    DPipe(OScore.Name[Place]);
    DGotoXY(42,Line);
    fg(7);
    DPipe(ItoS(OScore.Score[Place])); {Write the points to screen}
    Inc(Line);
  end;
  DGotoXY(8,19);
  DPipe('|12-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-');
  DGotoXY(1,23);
  HitEnter;
end;

Procedure Menu;
var
  option: Char; {Menu option}
begin
  Ag := TRUE;
  DClrScr;
  TnyBorderDisp;
  Header;
  if allowadd = True then    {Config file says I can let users add words}
  begin
    DGotoXY(2,9);
    DPipe('                       |15(|12P|15) |12P|04lay |12T|04he |12G|04ame');
    DGotoXY(2,10);
    DPipe('                       |15(|12A|15) |12A|04dd |12a n|04ew |12w|04ord');
    DGotoXY(2,11);
    DPipe('                       |15(|12I|15) |12I|04nformation |12O|04n |12T|04he |12D|04oor');
    DGotoXY(2,12);
    DPipe('                       |15(|12H|15) |12H|04igh |12S|04cores');
    DGotoXY(2,13);
    DPipe('                       |15(|12L|15) |12L|04ast |12M|04onths |12T|04op |12T|04en');
    DGotoXY(2,14);
    DPipe('                       |15(|12Q|15) |12Q|04uit');
    DGotoXY(2,16);
    DPipe('          |12M|04ake |12a s|04election|07: ');
    repeat
      option:= ReadkeySpin(40);
    until upcase(option) in ['A','Q','I','P','H','L'];
    case upcase(option) of
      'A': AddaWord;
      'Q': EndExit;
      'I': TnyInfo;
      'P': begin
        while Ag do
          if Nop = -1 then PlayTheGame          {Plays are unlimited so play}
          else if Playagain then PlayTheGame;   {User has plays left so play}
      end;
      'H': DisplayScore;
      'L': TopTen;
    end;
    end else                    {Config file says user can NOT add words}
  begin
    DGotoXY(2,9);
    DPipe('                       |15(|12P|15) |12P|04lay |12T|04he |12G|04ame');
    DGotoXY(2,10);
    DPipe('                       |15(|12I|15) |12I|04nformation |12O|04n |12T|04he |12D|04oor');
    DGotoXY(2,11);
    DPipe('                       |15(|12H|15) |12H|04igh |12S|04cores');
    DGotoXY(2,12);
    DPipe('                       |15(|12L|15) |12L|04ast |12M|04onths |12T|04op |12T|04en');
    DGotoXY(2,13);
    DPipe('                       |15(|12Q|15) |12Q|04uit');
    DGotoXY(2,15);
    DPipe('          |12M|04ake |12a s|04election|07: ');
    repeat
    option:= ReadkeySpin(40);
    until upcase(option) in ['Q','I','P','H','L'];
    case upcase(option) of
      'Q': EndExit;
      'I': TnyInfo;
      'P': begin
        while Ag do
          if Nop = -1 then PlayTheGame          {Plays are unlimited so play}
          else if Playagain then PlayTheGame;   {User has plays left so play}
      end;
      'H': DisplayScore;
      'L': TopTen;
    end;
  end;
end;

Procedure DetectAnsi;
var
 ch: Char;
begin
  fg(7);
  DClrScr;
  DPipeLn('Does your system support ANSI colour and graphics?');
  DPipe('|12A|14N|15S|09I |07[Y/n]');
  repeat
    ch:=readkeyspin(40);
  until upcase(ch) in ['Y','N',#13];
  case upcase(ch) of
    'N' : Endexit;
  end;
end;

Begin
  if (ParamStr(1) = '/?') or (ParamStr(1) = '?') then
  begin
    ClrScr;
    WriteLn('           Tiny''s Hangman Version 1.5b1');
    WriteLn('           -----------------------------');
    WriteLn;
    WriteLn('/?   - This screen ');
    WriteLn('/B#  - Sets the locked baud rate to #, ex. thang.exe /B57600 ');
    WriteLn('/D?  - Path to where the Drop file is found, ex. thang.exe /Dc:\bbs ');
    WriteLn('/L   - Local Mode ');
    WriteLn('/Nx  - x is the node number, ex. thang.exe /N1 ');
    WriteLn('/Hx  - Used for passing a hot OS/2 com handle to door');
    WriteLn('/S   - Display the current scores');
    WriteLn('/T   - Display the top ten scores');
    Halt(1);
  end;
  doorname := 'Tiny''s Hangman v2.1';
  cfgfn := 'thang.cfg';
  LoadCfg;
  quit := False;
  ReadTheConfig;                {Read my part of the config file}
  if (ParamStr(1) = '/S') then
  begin
    DisplayScore;
    quit:=True;
  end;
  if (ParamStr(1) = '/T') then
  begin
    TopTen;
    quit:=True;
  end;
  if not quit then
  begin
    fg(7);
    DClrScr;
    DetectAnsi;
    TnyTitle;
    HitEnter;
    Startup;                    {Do messing with datafiles}
  end;
  While not quit do Menu;       {Prevent recursion! It's EVIL!!}

End.
